{* plugins/generic/wdoi/templates/settings.tpl *}

<style>
  #wdoiSettingsForm { --gap:16px; box-sizing:border-box; width:100%; max-width:860px; padding:4px 8px 8px; margin:0 auto; }
  #wdoiSettingsForm .grid{ display:grid; grid-template-columns:minmax(0,1fr) minmax(0,1fr); gap:var(--gap); align-items:start; }
  #wdoiSettingsForm .grid > *{ min-width:0; }
  @media (max-width:920px){ #wdoiSettingsForm .grid{ grid-template-columns:minmax(0,1fr); } }
  #wdoiSettingsForm .pkpFormField{ margin:0; }
  #wdoiSettingsForm .pkpFormField__label{ display:block; font-weight:600; margin-bottom:6px; }
  #wdoiSettingsForm .pkpFormField__control{ display:block; }
  #wdoiSettingsForm .pkpFormField__input, #wdoiSettingsForm input[type="text"], #wdoiSettingsForm input[type="password"]{ width:100%; max-width:100%; box-sizing:border-box; }
  #wdoiSettingsForm .muted{ margin-top:6px; color:#6b7280; font-size:.92rem; line-height:1.35; overflow-wrap:anywhere; word-break:break-word; }
  #wdoiSettingsForm .mono input{ font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace; letter-spacing:.2px; }
  #wdoiSettingsForm .inline-action{ display:grid; grid-template-columns:minmax(0,1fr) auto; gap:10px; align-items:center; }
  #wdoiSettingsForm .eyeBtn{ border:0; background:transparent; color:#2563eb; cursor:pointer; padding:0 2px; font-size:.9rem; }
  #wdoiSettingsForm .pkpFormButtons{ margin-top:calc(var(--gap)*1.25); padding-top:6px; display:flex; justify-content:flex-end; }
</style>

<div class="pkpForm">
  <form id="wdoiSettingsForm"
        class="pkpForm"
        method="post"
        action="{url router=$smarty.const.ROUTE_COMPONENT op="manage" category="generic" plugin="wdoi" verb="settings"}">

    <input type="hidden" name="csrfToken" value="{$csrfToken|escape}">
    <input type="hidden" name="save" value="1">

    <h3 class="pkpHeader__title">{$tLegend}</h3>

    <div class="grid">

      {* API Base (full width) *}
      <div class="pkpFormField pkpFormField--text mono" style="grid-column:1 / -1;">
        <label class="pkpFormField__label" for="wdoiApiBase">{$tApiBase}</label>
        <span class="pkpFormField__control">
          <input class="pkpFormField__input" type="text" id="wdoiApiBase" name="wdoiApiBase"
                 placeholder="https://your-ngrok.ngrok-free.dev"
                 value="{$settings.wdoiApiBase|escape}">
        </span>
        <div class="muted">{$tApiBaseHelp}</div>
      </div>

      {* API Key *}
      <div class="pkpFormField pkpFormField--text mono">
        <label class="pkpFormField__label" for="wdoiApiKey">{$tApiKey}</label>
        <div class="inline-action">
          <input class="pkpFormField__input" type="password" id="wdoiApiKey" name="wdoiApiKey"
                 value="{$settings.wdoiApiKey|escape}">
          <button type="button" class="eyeBtn" aria-controls="wdoiApiKey" aria-label="Show API key">Show</button>
        </div>
        <div class="muted">{$tApiKeyHelp}</div>
      </div>

      {* Collection ID *}
      <div class="pkpFormField pkpFormField--text mono">
        <label class="pkpFormField__label" for="wdoiCollection">{$tCollection}</label>
        <span class="pkpFormField__control">
          <input class="pkpFormField__input" type="text" id="wdoiCollection" name="wdoiCollection"
                 value="{$settings.wdoiCollection|escape}">
        </span>
        <div class="muted">{$tCollectionHelp}</div>
      </div>

      {* Prefix *}
      <div class="pkpFormField pkpFormField--text mono">
        <label class="pkpFormField__label" for="wdoiPrefix">{$tPrefix}</label>
        <span class="pkpFormField__control">
          <input class="pkpFormField__input" type="text" id="wdoiPrefix" name="wdoiPrefix"
                 placeholder="10.34989"
                 value="{$settings.wdoiPrefix|escape}">
        </span>
        <div class="muted">{$tPrefixHelp}</div>
      </div>

      {* Resource Type *}
      <div class="pkpFormField pkpFormField--text">
        <label class="pkpFormField__label" for="wdoiResType">{$tResType}</label>
        <span class="pkpFormField__control">
          <input class="pkpFormField__input" type="text" id="wdoiResType" name="wdoiResType"
                 placeholder="ARTICLE"
                 value="{$settings.wdoiResType|escape}">
        </span>
        <div class="muted">{$tResTypeHelp}</div>
      </div>

    </div>

    <div class="pkpFormButtons">
      <button type="submit" class="pkpButton pkpButton--primary">{$tSave}</button>
    </div>
  </form>
</div>

<script>
  (function(){
    var btn = document.querySelector('#wdoiSettingsForm .eyeBtn');
    var input = document.getElementById('wdoiApiKey');
    if (!btn || !input) return;
    btn.addEventListener('click', function(){
      var show = input.type === 'password';
      input.type = show ? 'text' : 'password';
      btn.textContent = show ? 'Hide' : 'Show';
      btn.setAttribute('aria-label', (show ? 'Hide' : 'Show') + ' API key');
    });
  })();
</script>

<style>
  .wdoiToast{
    position:fixed; right:18px; bottom:18px;
    background:#10b981; color:white; padding:10px 14px;
    border-radius:8px; box-shadow:0 8px 24px rgba(0,0,0,.18);
    font-weight:600; opacity:0; transform:translateY(8px);
    transition:opacity .18s ease, transform .18s ease; z-index:999999;
  }
  .wdoiToast.show{ opacity:1; transform:translateY(0); }
</style>

<script>
(function(){
  var form = document.getElementById('wdoiSettingsForm');
  if (!form) return;
  form.addEventListener('submit', function(ev){
    ev.preventDefault();
    var fd = new FormData(form);
    fetch(form.action, { method:'POST', credentials:'same-origin', body:fd })
      .then(function(r){ return r.json(); })
      .then(function(json){
        if (json && json.status) {
          var msg = (json.content ? String(json.content).trim() : '');
          if (!msg || msg.indexOf('plugins.generic.wdoi.settings.saved') !== -1 ||
              /^#+plugins\.generic\.wdoi\.settings\.saved#+$/.test(msg)) {
            msg = 'wDOI settings saved';
          }
          var t = document.createElement('div');
          t.className = 'wdoiToast';
          t.setAttribute('role','status');
          t.setAttribute('aria-live','polite');
          t.textContent = msg;
          document.body.appendChild(t);
          requestAnimationFrame(function(){ t.classList.add('show'); });
          setTimeout(function(){ t.classList.remove('show'); setTimeout(function(){ t.remove(); },200); },1400);
          try { if (window.pkp && window.pkp.eventBus) { window.pkp.eventBus.$emit('modal:close'); }
                var m = document.querySelector('.pkpModal, .ui-dialog'); if (m && m.parentNode) m.parentNode.removeChild(m);
          } catch(e){}
          setTimeout(function(){ window.location.reload(); },250);
        } else {
          alert((json && json.content) ? json.content : 'Save failed');
        }
      })
      .catch(function(){ alert('Server error'); });
  });
})();
</script>
