<?php
// plugins/generic/wdoi/pages/WdoiDashboardHandler.inc.php

// ---- Compatibility shim: OJS 3.3 vs 3.4 ----
// Try modern namespaced base class (3.4+). If not present, fall back to 3.3 include.
if (class_exists('\\PKP\\core\\PKPHandler')) {
  class_alias('\\PKP\\core\\PKPHandler', 'WdoiBaseHandler');
} else {
  if (!class_exists('PKPHandler')) {
    require_once Core::getBaseDir() . '/lib/pkp/classes/handler/PKPHandler.inc.php';
  }
  class_alias('PKPHandler', 'WdoiBaseHandler');
}

use PKP\plugins\PluginRegistry;

class WdoiDashboardHandler extends WdoiBaseHandler {

  public function __construct() {
    parent::__construct();
    // Allow Journal Managers and Site Admins
    if (defined('ROLE_ID_MANAGER') && defined('ROLE_ID_SITE_ADMIN')) {
      $this->addRoleAssignment([ROLE_ID_MANAGER, ROLE_ID_SITE_ADMIN], ['index']);
    }
  }

  public function authorize($request, &$args, $roleAssignments) {
    return parent::authorize($request, $args, $roleAssignments);
  }

  public function index($args, $request) {
    $templateMgr = \APP\template\TemplateManager::getManager($request);

    // Get the plugin instance so we can resolve its templates
    $plugin = PluginRegistry::getPlugin('generic', 'wdoi');
    if (!$plugin) {
      // Fallback: simple echo if plugin not resolved (should not happen)
      echo '<div class="pkp_content_panel"><h2>wDOI</h2><p>Plugin not loaded.</p></div>';
      return;
    }

    // Assign whatever you want available in the template
    $templateMgr->assign([
      'pageTitle' => __('plugins.generic.wdoi.label') ?: 'wDOI',
    ]);

    // Render a plugin-relative template (standalone; no extends)
    $templateMgr->display($plugin->getTemplateResource('backend/dashboard.tpl'));
  }
}
