(function() {
  function injectWdoiField() {
    // Look for the DOI form field container
    const doiField = document.querySelector('.pkpFormField--doi, .pkpFormField--doiAssignment');
    if (!doiField) return;

    // Avoid duplicate
    if (document.querySelector('.pkpFormField--wdoi')) return;

    // Grab the stored wDOI value (backend already passes it in Smarty template)
    const wdoiValue = window.WDOI_SUBMISSION_WDOI || null;
    const label = window.WDOI_LABEL || 'wDOI';

    // Build new field
    const div = document.createElement('div');
    div.className = 'pkpFormField pkpFormField--text pkpFormField--wdoi';
    div.innerHTML = `
      <label class="pkpFormField__label">${label}</label>
      <div class="value">
        ${wdoiValue
          ? `<a href="https://wdoi.org/${wdoiValue}" target="_blank" rel="noopener">${wdoiValue}</a>`
          : `<span class="pkpBadge">${window.WDOI_NONE || 'None'}</span>`
        }
      </div>
    `;

    doiField.insertAdjacentElement('afterend', div);
  }

  // Run immediately + watch for dynamic changes
  const observer = new MutationObserver(injectWdoiField);
  observer.observe(document.body, { childList: true, subtree: true });
  injectWdoiField();
})();
