<?php
// OJS 3.3/3.4 compatible generic plugin

import('lib.pkp.classes.plugins.GenericPlugin');
import('lib.pkp.classes.core.JSONMessage');
import('lib.pkp.classes.linkAction.LinkAction');
import('lib.pkp.classes.linkAction.request.AjaxModal');

use APP\facades\Repo; // ✅ OJS 3.4 repo facade

require_once(__DIR__ . '/classes/WdoiClient.inc.php');
require_once(__DIR__ . '/classes/WdoiHelper.inc.php');

class WdoiPlugin extends GenericPlugin
{
  public function getName() { return 'wdoi'; }
/*   public function getDisplayName() { return __('plugins.generic.wdoi.displayName'); }
  public function getDescription() { return __('plugins.generic.wdoi.description'); } */

public function getDisplayName() {
    // make sure our locale file is loaded even if called before/without register()
    $this->addLocaleData();

    $s = __('plugins.generic.wdoi.displayName');
    if ($this->isMissingLocale($s)) {
        $s = 'Worldwide DOI (wDOI)'; // fallback
    }
    return $s;
}

public function getDescription() {
    // make sure our locale file is loaded even if called before/without register()
    $this->addLocaleData();

    $s = __('plugins.generic.wdoi.description');
    if ($this->isMissingLocale($s)) {
        $s = 'Integrates the Worldwide DOI (wDOI) registry with OJS: mint, update, display.'; // fallback
    }
    return $s;
}



  public function register($category, $path, $mainContextId = null) {
    if (!parent::register($category, $path)) return false;
    $this->addLocaleData();

    if ($this->getEnabled()) {
		HookRegistry::register('TemplateManager::display', function($hookName, $params) {
  $templateMgr =& $params[0];
  $request = Application::get()->getRequest();
  $page = $request->getRequestedPage();
  if ($page === 'workflow') {
    $templateMgr->addJavaScript(
      'wdoiSidebar',
      $this->getPluginPath() . '/js/wdoiSidebar.js',
      ['contexts' => 'backend']
    );
  }
  return false;
});
      // --- Lifecycle hooks ---
      HookRegistry::register('Publication::publish',   [$this, 'onPublish']);
      HookRegistry::register('Publication::unpublish', [$this, 'onUnpublish']);
HookRegistry::register('Schema::get::publication', [$this, 'extendPublicationSchema']);

      // --- Editor UI (sidebar) – show wDOI under DOI in Publication → Metadata ---
      // 3.3: this hook exists; 3.4: also works in most themes
      HookRegistry::register('Templates::Publication::Metadata', [$this, 'addWdoiFieldToMetadata']);

      // Some themes/panels use a slightly different hook; register a second one to be safe
      HookRegistry::register('Templates::Controllers\\Tab\\Publication\\Metadata::AdditionalMetadata', [$this, 'addWdoiFieldToMetadata']);

      // --- Public article page – show wDOI on the site ---
HookRegistry::register('Templates::Article::Main',    [$this, 'renderWdoiPublic']);
HookRegistry::register('Templates::Article::Details', [$this, 'renderWdoiPublic']);
HookRegistry::register('Templates::Article::Header',  [$this, 'renderWdoiPublic']);
	  
	  
	  // Route /wdoi to our handler
HookRegistry::register('LoadHandler', [$this, 'loadWdoiPage']);

// Inject a left-menu link under “Tools”
HookRegistry::register('TemplateManager::display', [$this, 'injectLeftNav']);
HookRegistry::register('TemplateManager::display', function($hookName, $args) {
  $templateMgr = $args[0];
  $request = Application::get()->getRequest();
  $submission = $templateMgr->getTemplateVars('submission');
  if ($submission) {
    $publication = method_exists($submission, 'getCurrentPublication') ? $submission->getCurrentPublication() : null;
    $wdoi = $publication ? $publication->getData('wdoi') : null;

    $templateMgr->addHeader(
      'wdoiSidebarInjector',
      '<script src="' . $request->getBaseUrl() . '/plugins/generic/wdoi/js/sidebarInjector.js"></script>
       <script>
         window.WDOI_SUBMISSION_WDOI = ' . json_encode($wdoi) . ';
         window.WDOI_LABEL = ' . json_encode(__('plugins.generic.wdoi.publicLabel')) . ';
         window.WDOI_NONE = ' . json_encode(__('common.none')) . ';
       </script>'
    );
  }
  return false;
});

    }

    return true;
  }


private function isMissingLocale($s) {
    return !$s || strpos($s, '##') !== false;
}




  public function getActions($request, $verb) {
    $actions = parent::getActions($request, $verb);
    if ($this->getEnabled()) {
      $dispatcher = $request->getDispatcher();
      $url = $dispatcher->url(
        $request,
        ROUTE_COMPONENT,
        null,
        'grid.settings.plugins.SettingsPluginGridHandler',
        'manage',
        null,
        ['verb' => 'settings', 'plugin' => $this->getName(), 'category' => $this->getCategory()]
      );
      $actions[] = new LinkAction(
        'settings',
        new AjaxModal($url, __('manager.plugins.settings'), 'modal_information'),
        __('manager.plugins.settings')
      );
    }
    return $actions;
  }


/** Add "wdoi" to the Publication schema so Repo::publication()->edit() will persist it */
public function extendPublicationSchema($hookName, $args) {
  /** @var stdClass $schema */
  $schema =& $args[0];

  if (!isset($schema->properties) || !is_object($schema->properties)) {
    $schema->properties = new stdClass();
  }

  // Simple non-multilingual string field
  $schema->properties->wdoi = (object)[
    'type' => 'string',
    'multilingual' => false
  ];

  // Optional: make it show up in API summaries (useful in future)
  if (!isset($schema->summaryProperties) || !is_array($schema->summaryProperties)) {
    $schema->summaryProperties = [];
  }
  if (!in_array('wdoi', $schema->summaryProperties, true)) {
    $schema->summaryProperties[] = 'wdoi';
  }

  return false; // don’t block other schema handlers
}

/** Wire the /wdoi backend page to our handler */
public function loadWdoiPage($hookName, $args) {
  $page =& $args[0];
  if ($page === 'wdoi') {
    define('HANDLER_CLASS', 'WdoiDashboardHandler');
    require_once($this->getPluginPath() . '/pages/WdoiDashboardHandler.inc.php');
    return true;
  }
  return false;
}

/** Add a “wDOIs” link to the backend left menu (under Tools or last section) */
public function injectLeftNav($hookName, $params) {
  /** @var TemplateManager $tm */
  $tm =& $params[0];

  $request = Application::get()->getRequest();
  $context = $request ? $request->getContext() : null;
  if (!$context) return false;

  $page = $request->getRequestedPage();
  if ($page === null) return false; // skip public

  $pageUrl = $request->getDispatcher()->url($request, ROUTE_PAGE, $context->getPath(), 'wdoi');
  $escapedUrl = htmlspecialchars($pageUrl, ENT_QUOTES, 'UTF-8');

  $script = <<<HTML
<script>
(function(){
  var MENU_TEXT = 'wDOIs';
  var MENU_URL  = '{$escapedUrl}';

  function findSidebarRoot() {
    return document.querySelector('.pkpSidebar')
        || document.querySelector('aside[role="navigation"]')
        || document.querySelector('#pkpSidebar')
        || null;
  }
  function pickTargetSection(sb) {
    var s = sb.querySelectorAll('.pkpSidebar__section, section, .sidebar-section');
    if (!s.length) return null;
    for (var i=0;i<s.length;i++){
      var h = s[i].querySelector('.pkpSidebar__title, h2, h3, header');
      var t = (h && h.textContent) ? h.textContent.trim().toLowerCase() : '';
      if (t && (t.indexOf('tools') !== -1 || t.indexOf('utilities') !== -1)) return s[i];
    }
    return s[s.length-1];
  }
  function findListInSection(section){
    return section.querySelector('ul, .pkpSidebar__items, .sidebar-items, nav ul');
  }
  function alreadyPresent(list){ return !!list.querySelector('a[href="'+MENU_URL+'"]'); }
  function addItem(list){
    var li = document.createElement('li');
    li.className = 'pkpSidebar__item';
    var a = document.createElement('a');
    a.className = 'pkpSidebar__link';
    a.href = MENU_URL;
    a.textContent = MENU_TEXT;
    li.appendChild(a);
    list.appendChild(li);
  }
  function tryInject(){
    var sb = findSidebarRoot(); if(!sb) return false;
    var sec = pickTargetSection(sb); if(!sec) return false;
    var list = findListInSection(sec); if(!list) return false;
    if (alreadyPresent(list)) return true;
    addItem(list); return true;
  }

  if (tryInject()) return;
  var tries = 0, max = 50;
  var timer = setInterval(function(){
    if (++tries > max) return clearInterval(timer);
    if (tryInject()) clearInterval(timer);
  }, 120);

  var obs = new MutationObserver(function(){
    if (tryInject()) obs.disconnect();
  });
  obs.observe(document.documentElement, { childList:true, subtree:true });
})();
</script>
HTML;

  if (method_exists($tm, 'addHeader')) {
    $tm->addHeader('wdoi-left-nav', $script, ['contexts' => 'backend']);
  }
  return false;
}

/* public function insertWdoiIntoArticle($hookName, $params) {
  $smarty =& $params[1];
  $output =& $params[2];

  $publication = $smarty->getTemplateVars('publication');
  if (!$publication) return false;

  $wdoi = $publication->getData('wdoi');
  if (!$wdoi) return false;

  $label = __('plugins.generic.wdoi.publicLabel') ?: 'wDOI';
  $html = '<section class="item wdoi"><h2>' . htmlspecialchars($label) . '</h2>'
        . '<p><a href="https://wdoi.org/' . htmlspecialchars($wdoi) . '" target="_blank" rel="noopener">'
        . htmlspecialchars($wdoi) . '</a></p></section>';

  $output .= $html;
  return false;
} */


/* public function insertWdoiIntoArticle($hookName, $params) {
  // $params[1] = TemplateManager, $params[2] = by-ref HTML buffer
  if (!isset($params[1]) || !isset($params[2])) return false;

  // @var TemplateManager $smarty
  $smarty =& $params[1];
  $output =& $params[2];

  $publication = $smarty->getTemplateVars('publication');
  if (!$publication) return false;

  $wdoi = (string) ($publication->getData('wdoi') ?? '');
  if ($wdoi === '') return false;

  $label = __('plugins.generic.wdoi.publicLabel');
  if (!$label || $label === 'plugins.generic.wdoi.publicLabel') {
    $label = 'wDOI';
  }

  // Prepend so it renders at the top of the page content
  $block  = '<section class="item item-wdoi" style="margin:0 0 1rem 0;padding:0.5rem 0;border-bottom:1px solid #eee">';
  $block .=   '<h2 style="margin:0 0 .5rem 0;font-size:1.25rem;line-height:1.2;">' . htmlspecialchars($label) . '</h2>';
  $block .=   '<p style="margin:0;"><a href="https://wdoi.org/' . htmlspecialchars($wdoi) . '" target="_blank" rel="noopener">' . htmlspecialchars($wdoi) . '</a></p>';
  $block .= '</section>';

  // Put our block before everything else on the page
  $output = $block . $output;
  return false;
} */



public function renderWdoiPublic($hookName, $params) {
  // We only handle the sidebar "details" block
  if ($hookName !== 'Templates::Article::Details') return false;
  if (!isset($params[1]) || !isset($params[2])) return false;

  /** @var TemplateManager $smarty */
  $smarty =& $params[1];
  $output =& $params[2];

  // Publication is provided on article pages
  $publication = $smarty->getTemplateVars('publication');
  if (!$publication) return false;

  $wdoi = (string) ($publication->getData('wdoi') ?? '');
  if ($wdoi === '') return false;

  // Label (fallback is "wDOI")
$label = __('plugins.generic.wdoi.publicLabel');
if (!$label || strpos($label, 'plugins.generic.wdoi.publicLabel') !== false) {
    $label = 'Worldwide DOI (wDOI)';
}


  // Build a row that matches DOI's structure (label + value)
// Build a row that matches DOI's structure (label on one line, value below)
$blockId = 'wdoi-item';
$block  = '<div id="' . $blockId . '" class="item wdoi">';
$block .=   '<div class="label">' . htmlspecialchars($label) . '</div>';
$block .=   '<div class="value"><a href="https://wdoi.org/' . htmlspecialchars($wdoi) . '" target="_blank" rel="noopener">' . htmlspecialchars($wdoi) . '</a></div>';
$block .= '</div>';


  // Append once; then move it just after "Published" on the client
  $script = '<script>
    (function(){
      function placeWdoi(){
        var w = document.getElementById("'.$blockId.'");
        if (!w) return;
        // Try common class names for the Published row:
        var published = document.querySelector(".item.published")
                      || document.querySelector(".article__details .item.published")
                      || document.querySelector(".pkp_block .item.published");
        if (published && published.parentNode) {
          if (published.nextSibling) {
            published.parentNode.insertBefore(w, published.nextSibling);
          } else {
            published.parentNode.appendChild(w);
          }
        } else {
          // Fallback: ensure it stays at the very top of the details list
          var details = document.querySelector(".article__details, .pkp_block, .obj_article_details, .sidebar .pkp_block");
          if (details && details.firstChild) details.insertBefore(w, details.firstChild);
        }
      }
      if (document.readyState === "loading") {
        document.addEventListener("DOMContentLoaded", placeWdoi);
      } else {
        placeWdoi();
      }
    })();
  </script>';

  // Append to the details output; JS will reposition it under "Published"
  $output .= $block . $script;
  return false;
}




public function manage($args, $request) {
  $this->addLocaleData();
  $verb = $request->getUserVar('verb');
  $context = $request->getContext();
  if (!$context) {
    error_log('[wDOI] No context in manage()');
    return new JSONMessage(false, __('plugins.generic.wdoi.err.noContext'));
  }
  $contextId = $context->getId();

  switch ($verb) {
case 'settings': {
    $this->addLocaleData(); // make sure locales are loaded

    $templateMgr = TemplateManager::getManager($request);
    $csrfToken   = $request->getSession()->getCSRFToken();

    $settingsKeys = ['wdoiApiBase','wdoiApiKey','wdoiCollection','wdoiPrefix','wdoiResType'];
    $settings = [];
    foreach ($settingsKeys as $k) {
        $settings[$k] = (string) ($this->getSetting($contextId, $k) ?? '');
    }

    // Helper to translate with a robust fallback if the key wasn't found
    $tr = function(string $key, string $fallback) : string {
        $s = __($key);
        if (!$s) return $fallback;
        // PKP returns the key itself or ##key## when missing; catch both
        if ($s === $key || strpos($s, $key) !== false || preg_match('/^#+'.preg_quote($key,'/').'+#$/', $s)) {
            return $fallback;
        }
        return $s;
    };

    // --- Save ---
    if ($request->getUserVar('save') === '1') {
        $tokenIn = $request->getUserVar('csrfToken');
        if (!$tokenIn || $tokenIn !== $csrfToken) {
            return new JSONMessage(false, $tr('form.csrfInvalid', 'Invalid security token'));
        }

        foreach ($settingsKeys as $k) {
            $v = trim((string) $request->getUserVar($k));
            $this->updateSetting($contextId, $k, $v);
            $settings[$k] = $v;
        }

        import('classes.notification.NotificationManager');
        $nm = new NotificationManager();

        $okMsg = $tr('plugins.generic.wdoi.settings.saved', 'wDOI settings saved');
        $nm->createTrivialNotification(
            $request->getUser()->getId(),
            NOTIFICATION_TYPE_SUCCESS,
            ['contents' => $okMsg]
        );

        $json = new JSONMessage(true, $okMsg);
        $json->setEvent('dataChanged');
        return $json;
    }

    // --- Render form ---
    $templateMgr->assign('csrfToken', $csrfToken);
    $templateMgr->assign('settings',  $settings);

    // Pass *resolved* strings into the template
    $templateMgr->assign([
        'tLegend'         => $tr('plugins.generic.wdoi.settings.legend', 'wDOI Registry Settings'),
        'tApiBase'        => $tr('plugins.generic.wdoi.apiBase', 'Registry API Base'),
        'tApiBaseHelp'    => $tr('plugins.generic.wdoi.apiBase.help', 'Base URL of your Registry service. Example: https://your-ngrok.ngrok-free.dev'),
        'tApiKey'         => $tr('plugins.generic.wdoi.apiKey', 'API Key'),
        'tApiKeyHelp'     => $tr('plugins.generic.wdoi.apiKey.help', 'A collection-scoped token with identifiers:mint/update/read permissions.'),
        'tCollection'     => $tr('plugins.generic.wdoi.collectionId', 'Collection ID'),
        'tCollectionHelp' => $tr('plugins.generic.wdoi.collectionId.help', 'The collection in which this journal’s items will be minted.'),
        'tPrefix'         => $tr('plugins.generic.wdoi.prefix', 'Prefix'),
        'tPrefixHelp'     => $tr('plugins.generic.wdoi.prefix.help', 'Your assigned wDOI prefix (e.g., 10.34989).'),
        'tResType'        => $tr('plugins.generic.wdoi.resourceType', 'Default Resource Type'),
        'tResTypeHelp'    => $tr('plugins.generic.wdoi.resourceType.help', 'e.g., ARTICLE'),
        'tSave'           => $tr('common.save', 'Save'),
    ]);

    $tpl = $this->getTemplateResource('settings.tpl');
    if (!$tpl) {
        error_log('[wDOI] Template resource not found for settings.tpl at plugin path ' . __DIR__);
        return new JSONMessage(false, 'Template missing: settings.tpl');
    }
    $html = $templateMgr->fetch($tpl);
    return new JSONMessage(true, $html);
}



/*     case 'settings': {
      $templateMgr = TemplateManager::getManager($request);
      $csrfToken = $request->getSession()->getCSRFToken();

      $settingsKeys = ['wdoiApiBase','wdoiApiKey','wdoiCollection','wdoiPrefix','wdoiResType'];
      $settings = [];
      foreach ($settingsKeys as $k) {
        $settings[$k] = (string) ($this->getSetting($contextId, $k) ?? '');
      }

      if ($request->getUserVar('save') === '1') {
        $tokenIn = $request->getUserVar('csrfToken');
        if (!$tokenIn || $tokenIn !== $csrfToken) {
          return new JSONMessage(false, __('form.csrfInvalid'));
        }
        foreach ($settingsKeys as $k) {
          $v = trim((string) $request->getUserVar($k));
          $this->updateSetting($contextId, $k, $v);
          $settings[$k] = $v;
        }
        import('classes.notification.NotificationManager');
        $nm = new NotificationManager();
        $nm->createTrivialNotification(
          $request->getUser()->getId(),
          NOTIFICATION_TYPE_SUCCESS,
          ['contents' => __('common.saved')]
        );
        $json = new JSONMessage(true);
        $json->setEvent('dataChanged');
        return $json;
      }

      $templateMgr->assign('csrfToken', $csrfToken);
      $templateMgr->assign('settings', $settings);

      $tpl = $this->getTemplateResource('settings.tpl');
      if (!$tpl) {
        error_log('[wDOI] Template resource not found for settings.tpl at plugin path ' . __DIR__);
        return new JSONMessage(false, 'Template missing: settings.tpl');
      }
      $html = $templateMgr->fetch($tpl);
      return new JSONMessage(true, $html);
    } */

    // ---------- Manual actions from sidebar ----------
    case 'mint':
    case 'update':
    case 'delete': {
      $tokenIn = $request->getUserVar('csrfToken');
      $csrfToken = $request->getSession()->getCSRFToken();
      if (!$tokenIn || $tokenIn !== $csrfToken) {
        return new JSONMessage(false, __('form.csrfInvalid'));
      }

      $submissionId = (int)$request->getUserVar('submissionId');
      if (!$submissionId) {
        return new JSONMessage(false, __('plugins.generic.wdoi.err.noSubmission'));
      }

      $submission = Repo::submission()->get($submissionId, $contextId);
      if (!$submission) {
        return new JSONMessage(false, __('plugins.generic.wdoi.err.noSubmission'));
      }

      $publication = $submission->getCurrentPublication();
      if (!$publication) {
        return new JSONMessage(false, __('plugins.generic.wdoi.err.noPublication'));
      }

      $client = $this->makeClient($contextId);
      if (!$client) {
        return new JSONMessage(false, 'wDOI not configured');
      }

      import('classes.notification.NotificationManager');
      $nm = new NotificationManager();

      try {
        $wdoi = (string) ($publication->getData('wdoi') ?? '');

        if ($verb === 'mint') {
          // Build public URL
          $dispatcher = $request->getDispatcher();
          $bestId = method_exists($submission, 'getBestId') ? $submission->getBestId() : $submission->getId();
          $targetUrl = $dispatcher->url(
            $request, ROUTE_PAGE, $context->getPath(), 'article', 'view', [$bestId]
          );

          $payload = WdoiHelper::buildMintPayload($this, $contextId, $publication, $submission, $request);
          $payload['targetUrl'] = $targetUrl;

          if (empty($payload['prefix']) || empty($payload['collectionId'])) {
            return new JSONMessage(false, 'Missing prefix or collectionId in settings');
          }

          $res = $client->post('/v1/identifiers', $payload);
          if ($res['ok'] && !empty($res['json']['wdoi'])) {
            $publication->setData('wdoi', $res['json']['wdoi']);                 // ✅ store on Publication
            Repo::publication()->edit($publication, ['wdoi']);                   // ✅ persist this prop
            $nm->createTrivialNotification($request->getUser()->getId(), NOTIFICATION_TYPE_SUCCESS, ['contents' => 'wDOI minted']);
            $json = new JSONMessage(true); $json->setEvent('dataChanged'); return $json;
          }
          return new JSONMessage(false, 'Mint failed: ' . ($res['body'] ?? ''));
        }

        if ($verb === 'update') {
          if (!$wdoi) return new JSONMessage(false, 'No wDOI to update');
          [$p, $s] = WdoiHelper::splitWdoi($wdoi);
          $payload = ['metadataJson' => WdoiHelper::buildMetadataJson($publication, $submission, $request)];
          $res = $client->put("/v1/identifiers/$p/$s", $payload);
          if ($res['ok']) {
            $nm->createTrivialNotification($request->getUser()->getId(), NOTIFICATION_TYPE_SUCCESS, ['contents' => 'wDOI updated']);
            $json = new JSONMessage(true); $json->setEvent('dataChanged'); return $json;
          }
          return new JSONMessage(false, 'Update failed: ' . ($res['body'] ?? ''));
        }

        if ($verb === 'delete') {
          if (!$wdoi) return new JSONMessage(false, 'No wDOI to delete');
          [$p, $s] = WdoiHelper::splitWdoi($wdoi);
          $res = $client->delete("/v1/identifiers/$p/$s", ['reason' => 'Manual delete']);
          if ($res['ok']) {
            $publication->setData('wdoi', null);                                  // ✅ clear on Publication
            Repo::publication()->edit($publication, ['wdoi']);
            $nm->createTrivialNotification($request->getUser()->getId(), NOTIFICATION_TYPE_SUCCESS, ['contents' => 'wDOI deleted']);
            $json = new JSONMessage(true); $json->setEvent('dataChanged'); return $json;
          }
          return new JSONMessage(false, 'Delete failed: ' . ($res['body'] ?? ''));
        }

      } catch (\Throwable $e) {
        error_log('[wDOI] manage '.$verb.' failed: '.$e->getMessage());
        return new JSONMessage(false, 'wDOI '.$verb.' failed');
      }
    }

    default:
      return parent::manage($args, $request);
  }
}



  /** Build client only if configured */
  private function makeClient($contextId) {
    $base = trim((string) ($this->getSetting($contextId, 'wdoiApiBase') ?? ''));
    $key  = trim((string) ($this->getSetting($contextId, 'wdoiApiKey') ?? ''));
    if ($base === '' || $key === '') return null;
    return new WdoiClient(rtrim($base, '/'), $key);
  }

  /** Fetch current submission via Repo (OJS 3.4 safe) */
  private function getSubmission($publication, $contextId = null) {
    $submissionId = $publication->getData('submissionId');
    if (!$submissionId) return null;
    // In 3.4 the contextId arg is optional in Repo::submission()->get()
    return Repo::submission()->get((int)$submissionId, $contextId);
  }

  // --------------------------
  // Hooks: UI (editor sidebar)
  // --------------------------
  /**
   * Append a read-only wDOI field under DOI in the Publication → Metadata sidebar.
   * Works in most OJS 3.3/3.4 themes.
   */
public function addWdoiFieldToMetadata($hookName, $params) {
  if (!isset($params[1]) || !isset($params[2])) return false;

  /** @var TemplateManager $smarty */
  $smarty =& $params[1];
  $output =& $params[2];

  $submission = $smarty->getTemplateVars('submission');
  if (!$submission) return false;

  $publication = method_exists($submission, 'getCurrentPublication')
    ? $submission->getCurrentPublication()
    : $smarty->getTemplateVars('publication');

  if (!$publication) return false;

  // ✅ read from Publication (where we now store it)
  $wdoi = (string) ($publication->getData('wdoi') ?? '');

  // Labels
$label = __('plugins.generic.wdoi.publicLabel');
if (!$label || strpos($label, 'plugins.generic.wdoi.publicLabel') !== false) {
    $label = 'Worldwide DOI (wDOI)';
}


  // Build manage URL & CSRF token for inline Ajax
  $request = Application::get()->getRequest();
  $dispatcher = $request->getDispatcher();
  $manageUrl = $dispatcher->url(
    $request,
    ROUTE_COMPONENT,
    null,
    'grid.settings.plugins.SettingsPluginGridHandler',
    'manage',
    null,
    ['plugin' => $this->getName(), 'category' => $this->getCategory()]
  );
  $csrf = $request->getSession()->getCSRFToken();

  // Read-only display block
  $html  = '<div class="pkpFormField pkpFormField--text">';
  $html .=   '<label class="pkpFormField__label">'.htmlspecialchars($label).'</label>';
  $html .=   '<div class="value">';
  if ($wdoi) {
    $html .=     '<a href="https://wdoi.org/'.htmlspecialchars($wdoi).'" target="_blank" rel="noopener">'.htmlspecialchars($wdoi).'</a>';
  } else {
    $html .=     '<span class="pkpBadge">'.__('common.none').'</span>';
  }
  $html .=   '</div>';
  $html .= '</div>';

  // Action buttons (Mint / Update / Delete)
  $html .= '<div id="wdoiSidebarActions" 
                 data-url="'.htmlspecialchars($manageUrl).'"
                 data-csrf="'.htmlspecialchars($csrf).'"
                 data-submission-id="'.(int)$submission->getId().'">';

  $html .=   '<button type="button" class="pkpButton pkpButton--action" data-action="mint" style="margin-right:6px;">Mint</button>';
  if ($wdoi) {
    $html .=   '<button type="button" class="pkpButton pkpButton--action" data-action="update" style="margin-right:6px;">Update</button>';
    $html .=   '<button type="button" class="pkpButton pkpButton--link" data-action="delete">Delete</button>';
  }
  $html .= '</div>';

  // Inline minimal JS to post actions
  $html .= '<script>
    (function() {
      var el = document.getElementById("wdoiSidebarActions");
      if (!el) return;
      function post(action) {
        var formData = new FormData();
        formData.append("verb", action);
        formData.append("submissionId", el.getAttribute("data-submission-id"));
        formData.append("csrfToken", el.getAttribute("data-csrf"));
        fetch(el.getAttribute("data-url"), { method: "POST", credentials: "same-origin", body: formData })
          .then(function(r){ return r.json(); })
          .then(function(json){
            if (json && json.status) { setTimeout(function(){ window.location.reload(); }, 600); }
            else { alert((json && json.content) ? json.content : "wDOI action failed"); }
          })
          .catch(function(){ alert("Server error"); });
      }
      el.addEventListener("click", function(e){
        var btn = e.target.closest("button[data-action]");
        if (!btn) return;
        var action = btn.getAttribute("data-action");
        if (action === "delete" && !confirm("Delete wDOI from Registry?")) return;
        post(action);
      });
    })();
  </script>';

  $output .= $html;
  return false;
}


  // --------------------------------
  // Hook: UI (public article page)
  // --------------------------------
public function addWdoiToArticle($hookName, $params) {
  if (!isset($params[1]) || !isset($params[2])) return false;

  /** @var TemplateManager $smarty */
  $smarty =& $params[1];
  $output =& $params[2];

  $publication = $smarty->getTemplateVars('publication');
  if (!$publication) return false;

  $wdoi = (string) ($publication->getData('wdoi') ?? '');
  if (!$wdoi) return false;

  $label = __('plugins.generic.wdoi.publicLabel');
  if (!$label || $label === 'plugins.generic.wdoi.publicLabel') $label = 'wDOI';

  $block  = '<section class="item wdoi" style="margin-top:1rem">';
  $block .=   '<h3>'.htmlspecialchars($label).'</h3>';
  $block .=   '<p><a href="https://wdoi.org/'.htmlspecialchars($wdoi).'" target="_blank" rel="noopener">'.htmlspecialchars($wdoi).'</a></p>';
  $block .= '</section>';

  $output .= $block;
  return false;
}


  // -----------------------
  // Lifecycle: on publish
  // -----------------------
/* public function onPublish($hookName, $args) {
  try {
    // @var \APP\publication\Publication $publication //
    [$publication] = $args;

    $request = Application::get()->getRequest();
    $context = $request ? $request->getContext() : null;
    if (!$context) return false;
    $contextId = $context->getId();

    $client = $this->makeClient($contextId);
    if (!$client) return false; // not configured; don’t block publish

    // Resolve submission (for bestId / URLs / metadata helpers)
    $submissionId = (int) $publication->getData('submissionId');
    $submission   = Repo::submission()->get($submissionId);
    if (!$submission) return false;

    // Build canonical public URL to the article view
    $bestId     = method_exists($submission, 'getBestId') ? $submission->getBestId() : $submission->getId();
    $dispatcher = $request->getDispatcher();
    $contextPath = $context->getData('path');
    $targetUrl = $dispatcher->url(
      $request,
      ROUTE_PAGE,
      $contextPath,
      'article',
      'view',
      [$bestId]
    );

    // ✅ Read wDOI from the Publication (persisted per version)
    $wdoi = (string) ($publication->getData('wdoi') ?? '');

    if ($wdoi) {
      // Update metadata on publish
      [$p, $s] = WdoiHelper::splitWdoi($wdoi);
      $payload = ['metadataJson' => WdoiHelper::buildMetadataJson($publication, $submission, $request)];
      $res = $client->put("/v1/identifiers/$p/$s", $payload);
      if (!$res['ok']) {
        error_log('[wDOI] update-on-publish failed: '.$res['code'].' '.$res['body']);
      }
      return false;
    }

    // Mint on publish
    $payload = WdoiHelper::buildMintPayload($this, $contextId, $publication, $submission, $request);
    $payload['targetUrl'] = $targetUrl;

    if (empty($payload['prefix']) || empty($payload['collectionId'])) {
      error_log('[wDOI] mint-on-publish aborted: missing prefix or collectionId in plugin settings');
      return false; // don’t block OJS publish
    }

    $res = $client->post('/v1/identifiers', $payload);
    if ($res['ok'] && !empty($res['json']['wdoi'])) {
      // ✅ Store on Publication and persist just that field
      $publication->setData('wdoi', $res['json']['wdoi']);
      Repo::publication()->edit($publication, ['wdoi']);
      error_log('[wDOI] mint OK: ' . $res['json']['wdoi'] . ' → ' . $targetUrl);
    } else {
      error_log('[wDOI] mint-on-publish failed: '.$res['code'].' '.$res['body']);
    }

  } catch (\Throwable $e) {
    // Never break OJS flow
    error_log('[wDOI] onPublish exception: ' . $e->getMessage());
  }
  return false; // allow default behavior
} */



public function onPublish($hookName, $args) {
  try {
    /** @var \APP\publication\Publication $publication */
    [$publication] = $args;

    $request = Application::get()->getRequest();
    $context = $request ? $request->getContext() : null;
    if (!$context) return false;
    $contextId = (int) $context->getId();

    $client = $this->makeClient($contextId);
    if (!$client) return false;

    // Resolve submission (for bestId / URLs / metadata helpers)
    $submissionId = (int) $publication->getData('submissionId');
    $submission   = Repo::submission()->get($submissionId);
    if (!$submission) return false;

    // Canonical article URL
    $bestId     = method_exists($submission, 'getBestId') ? $submission->getBestId() : $submission->getId();
    $dispatcher = $request->getDispatcher();
    $contextPath = $context->getData('path');
    $targetUrl = $dispatcher->url(
      $request,
      ROUTE_PAGE,
      $contextPath,
      'article',
      'view',
      [$bestId]
    );

    $wdoi = (string) ($publication->getData('wdoi') ?? '');

    if ($wdoi !== '') {
      // Re-publish of an item that already has a wDOI:
      // Reactivate + update metadata/target
      [$p, $s] = WdoiHelper::splitWdoi($wdoi);
      $payload = [
        'targetUrl'    => $targetUrl,
        'metadataJson' => WdoiHelper::buildMetadataJson($publication, $submission, $request),
        'status'       => 'active',           // <-- adjust to your API; makes it resolvable again
      ];
      $res = $client->put("/v1/identifiers/$p/$s", $payload);
      if (!$res['ok']) {
        error_log('[wDOI] republish update failed: '.$res['code'].' '.$res['body']);
      } else {
        error_log('[wDOI] republish update OK for '.$wdoi);
      }
      return false;
    }

    // First-time publish (no wDOI yet) -> mint
    $payload = WdoiHelper::buildMintPayload($this, $contextId, $publication, $submission, $request);
    $payload['targetUrl'] = $targetUrl;

    if (empty($payload['prefix']) || empty($payload['collectionId'])) {
      error_log('[wDOI] mint aborted: missing prefix or collectionId');
      return false;
    }

    $res = $client->post('/v1/identifiers', $payload);
    if ($res['ok'] && !empty($res['json']['wdoi'])) {
      $publication->setData('wdoi', $res['json']['wdoi']);
      Repo::publication()->edit($publication, ['wdoi']);
      error_log('[wDOI] mint OK: '.$res['json']['wdoi'].' → '.$targetUrl);
    } else {
      error_log('[wDOI] mint failed: '.$res['code'].' '.$res['body']);
    }

  } catch (\Throwable $e) {
    error_log('[wDOI] onPublish exception: ' . $e->getMessage());
  }
  return false;
}



  // -------------------------
  // Lifecycle: on unpublish
  // -------------------------
/* public function onUnpublish($hookName, $args) {
  try {
    [$publication] = $args;

    $request = Application::get()->getRequest();
    $context = $request ? $request->getContext() : null;
    if (!$context) return false;
    $contextId = $context->getId();

    $client = $this->makeClient($contextId);
    if (!$client) return false;

    // ✅ Read from Publication (not Submission)
    $wdoi = (string) ($publication->getData('wdoi') ?? '');
    if (!$wdoi) return false;

    [$p, $s] = WdoiHelper::splitWdoi($wdoi);
    $res = $client->delete("/v1/identifiers/$p/$s", ['reason' => 'Unpublished in OJS']);

    if ($res['ok']) {
      // ✅ Clear on Publication and persist just that field
      $publication->setData('wdoi', null);
      Repo::publication()->edit($publication, ['wdoi']);
      error_log('[wDOI] tombstone OK: ' . $p . '/' . $s);
    } else {
      error_log('[wDOI] tombstone-on-unpublish failed: '.$res['code'].' '.($res['body'] ?? ''));
    }
  } catch (\Throwable $e) {
    error_log('[wDOI] onUnpublish exception: ' . $e->getMessage());
  }
  return false;
} */


public function onUnpublish($hookName, $args) {
  try {
    /** @var \APP\publication\Publication $publication */
    [$publication] = $args;

    $request = Application::get()->getRequest();
    $context = $request ? $request->getContext() : null;
    if (!$context) return false;
    $contextId = (int) $context->getId();

    $client = $this->makeClient($contextId);
    if (!$client) return false;

    $wdoi = (string) ($publication->getData('wdoi') ?? '');
    if ($wdoi === '') return false;

    // OPTIONAL: If your registry supports a soft-state, call PUT to mark inactive/tombstoned.
    // We'll send a "status":"inactive" as an example; adjust to your API.
    try {
      [$p, $s] = WdoiHelper::splitWdoi($wdoi);
      $payload = [
        'status' => 'inactive',               // <-- adjust if your API uses another key/value
        // You can also update the target to a tombstone/withdrawn notice if you have one:
        // 'targetUrl' => $this->buildTombstoneUrl($request, $publication),
      ];
      $res = $client->put("/v1/identifiers/$p/$s", $payload);
      if (!$res['ok']) {
        error_log('[wDOI] onUnpublish: soft-deactivate failed: '.$res['code'].' '.($res['body'] ?? ''));
      } else {
        error_log('[wDOI] onUnpublish: soft-deactivated '.$wdoi);
      }
    } catch (\Throwable $e) {
      error_log('[wDOI] onUnpublish soft-deactivate exception: ' . $e->getMessage());
    }

    // IMPORTANT: Do NOT clear the wDOI from the publication.
    // Keeping it means a later publish will re-use and update it.

  } catch (\Throwable $e) {
    error_log('[wDOI] onUnpublish exception: ' . $e->getMessage());
  }
  return false;
}


}
